<?php

require_once __DIR__.'/vendor/autoload.php';

/**
 * The plugin bootstrap file
 *
 * @link              https://pay.umva.net
 * @since             1.0.0
 * @package           
 *
 * @wordpress-plugin
 * Plugin Name:       Umva Pay
 * Description:       THE FULL STACK OF PAYMENTS SOLUTIONS
 *                    Digital Payments For Global Businesses
 * Version:           1.0
 * Author:            UMVA BUSINESS Ltd.
 * Author URI:        https://pay.umva.net
 * Text Domain:       Umva Pay
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

define('XCASH_API_ENDPOINT', 'https://pay.umva.net');
define('XCASH_PLUGIN_VERSION', '1.0');
define('XCASH_PLUGIN_NAME', 'Umva Pay');
define('XCASH_ROOT', plugin_dir_path(__FILE__));
define('XCASH_PLUGIN_URL', str_replace('index.php','',plugins_url( 'index.php', __FILE__ )));

function xCash_init()
{
	if ( !class_exists( 'WC_Payment_Gateway' ) ) return;

	include 'gateway/class-gateway.php';

	add_filter('woocommerce_payment_gateways', 'xCash_gateway');

	function xCash_gateway( $methods )
	{
		$methods[] = 'XCashGateway';
		return $methods;
	}
    
    function account_add_notice() {
		echo '<div class="notice notice-warning">' . sprintf(
			esc_html__( 'Please set up your %s payment secret key, public key, and others from', XCASH_PLUGIN_NAME ),
			'<span>' . esc_html( XCASH_PLUGIN_NAME ) . '</span>'
		) . ' <a href="' . esc_url( admin_url( 'admin.php?page=wc-settings&tab=checkout&section=' . strtolower( xcash_title_to_key( XCASH_PLUGIN_NAME ) ) . '_gateway' ) ) . '">' . esc_html__( 'WooCommerce General Setting', XCASH_PLUGIN_NAME ) . '</a>.</div>';
	}
}

add_action( 'plugins_loaded', 'xCash_init' );

function xcash_enqueue_styles() {
	wp_enqueue_style( 'xcash-custom-styles', plugins_url( 'assets/style.css', __FILE__ ) );
}
add_action( 'wp_enqueue_scripts', 'xcash_enqueue_styles' );
